<?php
$tanggal = isset($_GET['tanggal']) ? $_GET['tanggal'] : date('Y-m-d');
$kelas = isset($_GET['kelas']) ? $_GET['kelas'] : 'all'; // Default semua kelas

// Ambil pengaturan absensi
$pengaturan = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM tb_absensi_umum_pengaturan LIMIT 1"));
$batas_terlambat = $pengaturan['batas_terlambat'];

// Query untuk filter kelas
$filter_kelas = ($kelas != 'all') ? "AND s.id_mkelas = '$kelas'" : "";

// Ambil data absensi dengan filter
$absensi = mysqli_query($con, "
    SELECT s.nis, s.nama_siswa, k.nama_kelas, a.jam_masuk, a.status_masuk, a.jam_pulang, a.status_pulang
    FROM tb_siswa s
    LEFT JOIN tb_mkelas k ON s.id_mkelas = k.id_mkelas
    LEFT JOIN tb_absensi_umum a ON s.nis = a.nis AND a.tanggal = '$tanggal'
    WHERE 1=1 $filter_kelas
    ORDER BY s.nama_siswa ASC
");

// Ambil daftar kelas untuk dropdown
$kelas_options = mysqli_query($con, "SELECT id_mkelas, nama_kelas FROM tb_mkelas ORDER BY nama_kelas");
?>

<div class="card">
  <div class="card-header">
    <h4 class="card-title">Laporan Absensi Harian</h4>
    <form method="GET" class="form-inline">
    <input type="hidden" name="page" value="rekap-absenumum">
      <div class="form-group mr-2">
        <label for="tanggal">Tanggal:</label>
        <input type="date" name="tanggal" id="tanggal" class="form-control ml-2" value="<?= $tanggal ?>">
      </div>
      
      
      <div class="form-group mr-2">
        <label for="kelas">Kelas:</label>
        <select name="kelas" id="kelas" class="form-control ml-2">
          <option value="all">Semua Kelas</option>
          <?php while($k = mysqli_fetch_assoc($kelas_options)): ?>
            <option value="<?= $k['id_mkelas'] ?>" <?= ($kelas == $k['id_mkelas']) ? 'selected' : '' ?>>
              <?= $k['nama_kelas'] ?>
            </option>
          <?php endwhile; ?>
        </select>
      </div>
      
      <button type="submit" class="btn btn-primary">Filter</button>
    </form>
  </div>
  
  <div class="card-body">
    <table class="table table-bordered table-striped">
      <thead class="thead-dark">
        <tr>
          <th>No</th>
          <th>NIS</th>
          <th>Nama</th>
          <th>Kelas</th>
          <th>Jam Masuk</th>
          <th>Status Masuk</th>
          <th>Jam Pulang</th>
          <th>Status Pulang</th>
        </tr>
      </thead>
      <tbody>
        <?php
        $no = 1;
        while ($row = mysqli_fetch_assoc($absensi)) {
          $terlambat_masuk = '';
          if (!empty($row['jam_masuk']) && $row['status_masuk'] == '0') {
            $menit_terlambat = round((strtotime($row['jam_masuk']) - strtotime($batas_terlambat)) / 60);
            $terlambat_masuk = "<span class='text-danger'>(Terlambat {$menit_terlambat} menit)</span>";
          }

          echo "<tr>
                  <td>{$no}</td>
                  <td>{$row['nis']}</td>
                  <td>{$row['nama_siswa']}</td>
                  <td>{$row['nama_kelas']}</td>
                  <td>" . ($row['jam_masuk'] ?? '-') . "</td>
                  <td>" . ($row['status_masuk'] === null ? '<span class="text-secondary">Belum Hadir</span>' : ($row['status_masuk'] == '1' ? '<span class="text-success">Tepat Waktu</span>' : '<span class="text-danger">Terlambat</span> ' . $terlambat_masuk)) . "</td>
                  <td>" . ($row['jam_pulang'] ?? '-') . "</td>
                  <td>" . ($row['status_pulang'] === null ? '<span class="text-secondary">Belum Pulang</span>' : ($row['status_pulang'] == '1' ? '<span class="text-success">Tepat Waktu</span>' : '<span class="text-warning">Terlambat</span>')) . "</td>
                </tr>";
          $no++;
        }
        ?>
      </tbody>
    </table>
  </div>
</div>

<!-- Tambahan: Rekapitulasi -->
<div class="row mt-4">
  <div class="col-md-4">
    <div class="card bg-light">
      <div class="card-body">
        <h5>Belum Hadir</h5>
        <ul>
          <?php
          $belum_query = "SELECT s.nama_siswa FROM tb_siswa s 
                         WHERE s.nis NOT IN (
                           SELECT nis FROM tb_absensi_umum WHERE tanggal = '$tanggal'
                         ) $filter_kelas
                         ORDER BY s.nama_siswa ASC";
          $belum = mysqli_query($con, $belum_query);
          
          while ($row = mysqli_fetch_assoc($belum)) {
            echo "<li>{$row['nama_siswa']}</li>";
          }
          
          if(mysqli_num_rows($belum) == 0) {
            echo "<li>Tidak ada siswa yang belum hadir</li>";
          }
          ?>
        </ul>
      </div>
    </div>
  </div>
  
  <div class="col-md-4">
    <div class="card bg-light">
      <div class="card-body">
        <h5>Terlambat Datang</h5>
        <ul>
          <?php
          $terlambat_query = "SELECT s.nama_siswa FROM tb_absensi_umum a 
                             JOIN tb_siswa s ON a.nis = s.nis
                             WHERE a.tanggal = '$tanggal' AND a.status_masuk = '0' $filter_kelas";
          $terlambat = mysqli_query($con, $terlambat_query);
          
          while ($row = mysqli_fetch_assoc($terlambat)) {
            echo "<li>{$row['nama_siswa']}</li>";
          }
          
          if(mysqli_num_rows($terlambat) == 0) {
            echo "<li>Tidak ada siswa yang terlambat</li>";
          }
          ?>
        </ul>
      </div>
    </div>
  </div>
</div>