<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__.'/../assets/libs/madeline81.phar';

use danog\MadelineProto\API;
use danog\MadelineProto\Settings;
use danog\MadelineProto\Settings\AppInfo;
use danog\MadelineProto\Settings\Logger;

// Ambil API ID dan Hash dari database
$query = $con->query("SELECT * FROM tb_koneksi_tg ORDER BY id DESC LIMIT 1");
$tg = $query->fetch_assoc();

// Handle form pengaturan API
if (isset($_POST['simpan_api'])) {
    ob_start(); // Tambahkan baris ini untuk menangkap output

    $api_id = intval($_POST['api_id']);
    $api_hash = $con->real_escape_string($_POST['api_hash']);
    $con->query("INSERT INTO tb_koneksi_tg (api_id, api_hash) VALUES ($api_id, '$api_hash')");
    
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}


// Tampilkan notifikasi
$msg = null;
if (!$tg) {
    $msg = "Silakan atur API ID dan API Hash terlebih dahulu.";
}

$info = null;
$error = null;
$session_file = '../assets/libs/session.madeline';

if ($tg) {
    try {
        $settings = (new Settings)
            ->setAppInfo((new AppInfo)
                ->setApiId($tg['api_id'])
                ->setApiHash($tg['api_hash'])
            )
            ->setLogger((new Logger)->setMaxSize(10 * 1024));

        $MadelineProto = new API($session_file, $settings);
        $MadelineProto->start();
        $info = $MadelineProto->getSelf();

        // Kirim pesan jika form diisi
        if (isset($_POST['kirim_pesan'])) {
            $peer = $_POST['tujuan'];
            $text = $_POST['pesan'];
            $MadelineProto->messages->sendMessage([
                'peer' => $peer,
                'message' => $text
            ]);
            $msg = "Pesan berhasil dikirim ke $peer";
        }
    } catch (Exception $e) {
        $error = $e->getMessage();
    }
}
?>

<div class="panel-header bg-primary-gradient">
    <div class="page-inner py-5">
        <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
            <div>
                <h5 class="text-white op-7 mb-2">Pengaturan Koneksi Telegram</h5>
            </div>
        </div>
    </div>
</div>

<div class="page-inner mt--5">
    <div class="row">
        <div class="col-md-6 offset-md-3">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Atur API Telegram</h4>
                </div>
                <div class="card-body">
                    <?php if ($msg): ?>
                        <div class="alert alert-success"> <?= $msg ?> </div>
                    <?php endif; ?>
                    <?php if ($error): ?>
                        <div class="alert alert-danger"> <?= htmlspecialchars($error) ?> </div>
                    <?php endif; ?>

                    <form method="POST">
                        <div class="form-group">
                            <label>API ID</label>
                            <input type="number" name="api_id" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label>API HASH</label>
                            <input type="text" name="api_hash" class="form-control" required>
                        </div>
                        <button type="submit" name="simpan_api" class="btn btn-primary">Simpan</button>
                    </form>
                </div>
            </div>

            <?php if ($info): ?>
            <div class="card mt-4">
                <div class="card-header">
                    <h4 class="card-title">Status Koneksi Telegram</h4>
                </div>
                <div class="card-body">
                    <p>Login sebagai: <b><?= htmlspecialchars($info['username'] ?? $info['first_name']) ?></b></p>
                </div>
            </div>

            <div class="card mt-4">
                <div class="card-header">
                    <h4 class="card-title">Tes Kirim Pesan</h4>
                </div>
                <div class="card-body">
                    <form method="POST">
                        <div class="form-group">
                            <label>Tujuan (username atau ID)</label>
                            <input type="text" name="tujuan" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label>Pesan</label>
                            <textarea name="pesan" class="form-control" required></textarea>
                        </div>
                        <button type="submit" name="kirim_pesan" class="btn btn-success">Kirim Pesan</button>
                    </form>
                </div>
            </div>
            <?php endif; ?>

            <div class="card mt-4">
                <div class="card-header">
                    <h4 class="card-title">Cara Mendapatkan API ID & HASH</h4>
                </div>
                <div class="card-body">
                    <ol>
                        <li>Buka <a href="https://my.telegram.org/apps" target="_blank">https://my.telegram.org/apps</a></li>
                        <li>Login dengan nomor Telegram kamu</li>
                        <li>Pilih "API Development Tools"</li>
                        <li>Isi nama aplikasi (bebas), URL, dan deskripsi</li>
                        <li>Setelah disubmit, akan muncul API ID dan API Hash</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>
