<!DOCTYPE html>
<html>
<head>
    <title>Bukti Peminjaman Uang</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            width: 90mm;
            margin: 3mm;
            padding: 0;
            font-size: 13px;
            line-height: 1.4;
        }
        .header {
            text-align: center;
            margin-bottom: 8px;
        }
        .title {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 3px;
        }
        .section {
            margin: 8px 0;
        }
        .info-row {
            margin-bottom: 4px;
        }
        .label {
            font-weight: bold;
            display: inline-block;
            width: 30mm;
        }
        .amount {
            text-align: center;
            font-size: 15px;
            font-weight: bold;
            margin: 10px 0;
            padding: 5px 0;
            background: #f5f5f5;
        }
        .signature {
            margin-top: 15px;
            padding-top: 10px;
            text-align: center;
        }
        .footer {
            text-align: center;
            margin-top: 10px;
            font-size: 11px;
        }
        hr {
            border: none;
            border-top: 1px solid #eee;
            margin: 8px 0;
        }
    </style>
</head>
<body>

<?php
include "../../config/conn.php";
$loan = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM transaksi WHERE id_transaksi='$_GET[id_tran]'"));
$peminjam = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM pekerja WHERE id_pekerja='$loan[id_piutang]'"));
$pemberi = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM pegawai WHERE id_pegawai='$loan[id_pegawai]'"));
?>

<div class="header">
    <div class="title">BUKTI PEMINJAMAN UANG</div>
    <div>Id Trx : <?php echo $loan['id_transaksi']; ?></div>
</div>

<hr>

<div class="section">
    <div class="info-row">
        <span class="label">Tanggal</span>: <?php echo date('d/m/Y', strtotime($loan['tanggal'])); ?>
    </div>
    <div class="info-row">
        <span class="label">Peminjam</span>: <?php echo $peminjam['id_pekerja']; ?> - <?php echo $peminjam['nama_pekerja']; ?>
    </div>
</div>

<div class="amount">
    JUMLAH PINJAM<br>
    Rp <?php echo number_format($loan['kredit'], 0, ',', '.'); ?>
</div>

<div class="section">
    <div class="info-row">
        <span class="label">Keterangan</span>: <?php echo $loan['keterangan']; ?>
    </div>
    <div class="info-row">
        <span class="label">Pemberi Pinjaman</span>: (<?php echo $pemberi['id_pegawai']; ?>)<?php echo $pemberi['nama']; ?>
    </div>
</div>

<div class="signature">
    Tanda Tangan Peminjam<br><br><br><br>
    (<?php echo $peminjam['nama_pekerja']; ?>)
</div>

<div class="footer">
    Dicetak: <?php echo date('d/m/Y'); ?>
</div>

<script>
    window.print();
    setTimeout(window.close, 500);
</script>

</body>
</html>