<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Laporan Harian Transaksi</title>
    <style>
        body {
            font-family: Verdana, sans-serif;
            font-size: 12px;
            color: #000;
            margin: 20px;
        }
        h2 {
            text-align: center;
            margin-bottom: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        th, td {
            border: 1px solid #333;
            padding: 6px 10px;
            text-align: right;
        }
        th {
            background-color: #f2f2f2;
        }
        td:first-child, th:first-child {
            text-align: center;
        }
        td:nth-child(2), th:nth-child(2) {
            text-align: left;
        }
        .summary {
            margin-top: 20px;
            font-weight: bold;
        }
        .text-left {
            text-align: left;
        }
        @media print {
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>

<h2>LAPORAN TRANSAKSI HARIAN - <?= $hariini ?></h2>

<table>
    <thead>
        <tr>
            <th>No.</th>
            <th>Jenis Kas</th>
            <th>Pemasukan</th>
            <th>Pengeluaran</th>
            <th>Total</th>
            <th>+ Uang Awal</th>
            <th>- Bawa Uang</th>
            <th>+ Kembali Bawa Uang</th>
            <th>Total Akhir</th>
        </tr>
    </thead>
    <tbody>
        <?php $no = 1; while ($row = mysqli_fetch_array($query)) : ?>
        <tr>
            <td><?= $no++ ?></td>
            <td><?= $row['nama'] ?></td>
            <td><?= rupiah($row['jumlah_debit']) ?></td>
            <td><?= rupiah($row['jumlah_kredit']) ?></td>
            <td><?= rupiah($row['jumlah_debit'] - $row['jumlah_kredit']) ?></td>
            <td><?= rupiah($row['jumlah_uangawal']) ?></td>
            <td><?= rupiah($row['jumlah_bawa_tgl_bawa']) ?></td>
            <td><?= rupiah($row['jumlah_bawa_tgl_totalan']) ?></td>
            <td><strong><?= rupiah($row['jumlah_debit'] - $row['jumlah_kredit'] + $row['jumlah_uangawal'] - $row['jumlah_bawa_tgl_bawa'] + $row['jumlah_bawa_tgl_totalan']) ?></strong></td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<div class="summary text-left">
    <p>Total Debit: Rp <?= rupiah($row_saldo['jumlah_debit']) ?></p>
    <p>Total Kredit: Rp <?= rupiah($row_saldo['jumlah_kredit']) ?></p>
    <p>Saldo Akhir: Rp <?= rupiah($saldo_keseluruhan) ?></p>
</div>

<script>
    window.print();
</script>

</body>
</html>
